package org.msh.tb.bd.tbforms.dhis2.data;

/**
 * Created by Mauricio on 03/02/2017.
 * DTO that holds data values to be used on request payload when sending the request.
 */
public class DataElementValue {

    /**
     * Mandatory
     * Data element id in DHIS2
     */
    private String dataElement;

    /**
     * Not Mandatory
     * The category id inn DHIS2, i.e. age-sex for TB10 Block 1
     */
    private String categoryOptionCombo;

    /**
     * The indicator value
     */
    private Long value;

    public DataElementValue(String dataElement, String categoryOptionCombo, Long value) {
        this.dataElement = dataElement;
        this.categoryOptionCombo = categoryOptionCombo;
        this.value = value;
    }

    public String getDataElement() {
        return dataElement;
    }

    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public String getCategoryOptionCombo() {
        return categoryOptionCombo;
    }

    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public Long getValue() {
        return value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    /**
     * Sums the current value with the value on parameter
     * @param value value that will be summed to the current value
     * @return the result of the sum of the current value with the value on parameter
     */
    public Long mergeValue(Long value){
        if (this.value == null) {
            this.value = value;
        } else {
            this.value += value;
        }

        return this.value;
    }
}
